<?php
$theme_name = "Hybrid";
$theme_version = "1.1.0";
global $theme_name;
global $theme_version;

define( 'ACF_LITE' , false );
include_once('advanced-custom-fields/acf.php' );

include('includes/post-types.php');
include('includes/shortcodes.php');
include('widgets/widget-twitter.php');
include('widgets/widget-testimonials.php');
include('widgets/widget-blogposts.php');
include('widgets/widget-blogpost2.php');
include('widgets/widget-blogpost3.php');
include('widgets/facebook.php');
include('widgets/widget-adv.php');
include('widgets/widget-contactus.php');
include('widgets/widget-about.php');
include('widgets/widget-instagram.php');
include('widgets/widget-flickr.php');
include('tgm/plugins.php');
include('includes/st_font-style.php');
include('includes/custume-fields.php');
/*ACF*/
// Fields


    function my_register_fields()
    {
        include_once('includes/add-ons/acf-repeater/repeater.php');
        include_once('includes/add-ons/advanced-custom-fields-code-area-field/acf_code_area-v4.php');
        include_once('includes//add-ons/acf-flexible-content/flexible-content.php');
    }
    add_action('acf/register_fields', 'my_register_fields');

// Options Page
    include_once( 'includes/add-ons/acf-options-page/acf-options-page.php' );

    if(function_exists("register_options_page"))
    {
        if(current_user_can('edit_theme_options')){
            register_options_page('Main','');
			register_options_page('Branding','');
			register_options_page('Header','');
			register_options_page('Footer','');
        }
    }
    register_options_page();

/*ACF*/


/*Google*/
    add_action('acf/register_fields', 'register_fields');
    function register_fields()
    {
        include_once('registered-fields/presets/acf-presets.php');
        include_once('registered-fields/google-font/acf-googlefonts.php');
        include_once('registered-fields/googlemap/acf-googlemap.php');
    }
/*Google*/

if ( ! isset( $content_width ) ) $content_width = 940;
    
/*Supports images in posts*/
add_theme_support( 'automatic-feed-links' );
add_theme_support( 'post-thumbnails' );

/*Image sizes*/
add_image_size('home1-blog',285,160,true);   
add_image_size("home3-slider",  1920 , 1280, true);
//add_image_size("logo",  100 , 26, true);
add_image_size("work_post_Slider", 270 , 160, true);
add_image_size("home2-featured", 570 , 320, true);
add_image_size("home2-blog", 266 , 198, true);
add_image_size("our-team", 270, 150, true);
add_image_size("adv", 110, 110, true);
/*Image sizes */
	
/*Excerpt*/
 function custom_excerpt_length($length)
	{
	   return 20;
	}
	add_filter( 'excerpt_length', 'custom_excerpt_length');

	function new_excerpt_more($more )
	{
		return '...';
	}
	add_filter('excerpt_more', 'new_excerpt_more');
/*Excerpt*/

function curPageURL() {
	 $pageURL = 'http';
	 if(isset($_SERVER["HTTPS"]))
	 {
	 if ($_SERVER["HTTPS"] == "on") {$pageURL .= "s";}
	 }
	 $pageURL .= "://";
	 if ($_SERVER["SERVER_PORT"] != "80") {
	  $pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
	 } else {
	  $pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
	 }
	 return $pageURL;
	}
	
	
/*Add Menu Support*/
add_action( 'init', 'register_my_menus' );
function register_my_menus() {
    register_nav_menus(array( 'primary'=>'Primary Menu')
    );
}
/*Add Menu Support*/

/*register Sidebar*/
function st_hybrid_widgets_init()
{
    register_sidebar( array(
        'name' => __( 'Main Sidebar', 'hybrid_lang' ),
        'id' => 'sidebar-1',
        'before_widget' => '<div id="blog-sidebar">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'

    ) );
	register_sidebar( array(
        'name' => __( 'Home1 Sidebar', 'hybrid_lang' ),
        'id' => 'sidebar-2',
        'before_widget' => '<div id="blog-sidebar" class="span3">',
        'after_widget' => "</div>",
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ) );
	register_sidebar( array(
        'name' => __( 'Home2 Sidebar', 'hybrid_lang' ),
        'id' => 'sidebar-3',
        'before_widget' => '<div id="blog-sidebar" class="span3">',
        'after_widget' => "</div>",
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ) );
}

add_action( 'widgets_init', 'st_hybrid_widgets_init' );
/*register Sidebar*/
/*Admin js and css*/

add_action('admin_print_scripts', 'add_my_scripts');
add_action( 'admin_print_styles', 'load_custom_admin_css' );

function add_my_scripts()
{
    wp_enqueue_script("adminJS", get_template_directory_uri()."/js/adminJS.js" ,array(),'',TRUE);
}
function load_custom_admin_css()
{
    wp_enqueue_style("font_awesome", get_template_directory_uri().'/css/font-awesome.css' , false, "1.0");
    wp_enqueue_style("adminCss", get_template_directory_uri().'/css/adminCss.css' , false, "1.0");

}
/*Admin js and css*/

	/*css*/		
        function add_external_stylesheets()
        {
            wp_enqueue_style("main", get_stylesheet_uri() , false, "1.0");			
            wp_enqueue_style("bootstrap", get_template_directory_uri()."/css/bootstrap.css" , false, "1.0");
			wp_enqueue_style("bootstrap-responsive",get_template_directory_uri()."/css/bootstrap-responsive.css",false, "1.0");			
			wp_enqueue_style("Style",get_template_directory_uri()."/css/style.css", false, "1.0");
			wp_enqueue_style("Font",get_template_directory_uri()."/css/font-awesome.css", false, "1.0");
			wp_enqueue_style("latestWorks",get_template_directory_uri()."/css/latestWorks.css", false, "1.0");
			wp_enqueue_style("blogPosts",get_template_directory_uri()."/css/blogPosts.css", false, "1.0");
			wp_enqueue_style("mCustomScr",get_template_directory_uri()."/css/jquery.mCustomScrollbar.css", false, "1.0");
			wp_enqueue_style("tablet",get_template_directory_uri()."/css/tablet.css", false, "1.0");
			wp_enqueue_style("animate",get_template_directory_uri()."/css/animate.css", false, "1.0");
			wp_enqueue_style("superslide",get_template_directory_uri()."/css/superslides.css", false, "1.0");
			
			$skin = get_field('choose_skin','options');
			if($skin){
				wp_enqueue_style($skin,get_template_directory_uri()."/css/".$skin.".css", false, "1.0");
			}
			else{
				wp_enqueue_style("default-css",get_template_directory_uri()."/css/default.css", false, "1.0");
			}
			
        }
		add_action( 'wp_enqueue_scripts', 'add_external_stylesheets' );
	/*css*/

	/*javascript*/
	
        function add_external_JS()
        {          
			wp_enqueue_script('jquery');  
			wp_enqueue_script("google_map","https://maps.googleapis.com/maps/api/js?sensor=true",'','',TRUE);
			wp_enqueue_script("imagesloaded",get_template_directory_uri()."/js/imagesloaded.pkgd.js", array(),'',TRUE);
			wp_enqueue_script("bootstrap-js",get_template_directory_uri()."/js/bootstrap.js", array(),'',TRUE);
			wp_enqueue_script("hammer", get_template_directory_uri()."/js/hammer.min.js" , array(),'',TRUE);
			wp_enqueue_script("script-js",get_template_directory_uri()."/js/script.js", array(),'',TRUE);
			wp_enqueue_script("latestWorks",get_template_directory_uri()."/js/jquery.latestWorks.js", array(),'',TRUE);
			wp_enqueue_script("blogPosts",get_template_directory_uri()."/js/jquery.blogPosts.js", array(),'',TRUE);
			wp_enqueue_script("LoadMore",get_template_directory_uri()."/js/LoadMore.js", array(),'',TRUE);
			wp_enqueue_script("isotope",get_template_directory_uri()."/js/jquery.isotope.js", array(),'',TRUE);
			wp_enqueue_script("mcostumscrollbar", get_template_directory_uri()."/js/jquery.mCustomScrollbar.js",array(),'',TRUE);            
			wp_enqueue_script("mousewheel", get_template_directory_uri()."/js/jquery.mousewheel.js" , array(),'',TRUE);
		    wp_enqueue_script("shortcode-script", get_template_directory_uri()."/js/shortcodesScript.js" , array(),'',TRUE);
			wp_enqueue_script("easing", get_template_directory_uri()."/js/jquery.easing.1.3.js" , array(),'',TRUE);
			wp_enqueue_script("animate-enhanced", get_template_directory_uri()."/js/jquery.animate-enhanced.min.js" , array(),'',TRUE);
			wp_enqueue_script("superslides", get_template_directory_uri()."/js/jquery.superslides.js" , array(),'',TRUE);
			wp_enqueue_script("blogviews", get_template_directory_uri()."/js/blogview.js" , array(),'',TRUE);
            if ( is_singular() ){
                wp_enqueue_script( 'comment-reply','',array(),'',TRUE );
            }			
        }
		add_action( 'wp_enqueue_scripts', 'add_external_JS' );
	/*javascript*/
	/* Font */
	function register_custom_fonts(){
	 $all_font = get_field('headings_font','options');
        if(isset($all_font['family'])){
            wp_enqueue_style("Content-Font","http://fonts.googleapis.com/css?family=".$all_font['family'], false, "1.0");
        }       
        
         $paragraphs_font = get_field('paragraphs_font','options');
        if(isset($paragraphs_font['family'])){
              wp_enqueue_style("Content-Font2","http://fonts.googleapis.com/css?family=".$paragraphs_font['family'], false, "1.0");		
        }
      
		$logo_font = get_field('text_logo_font','options');
		if(isset($logo_font['family'])){
			wp_enqueue_style("LogoFont1","http://fonts.googleapis.com/css?family=".$logo_font['family'], false, "1.0");			
		}
		
		$font = get_field('font');
		if(isset($font['family'])){
			wp_enqueue_style("LogoFont","http://fonts.googleapis.com/css?family=".$font['family'], false, "1.0");	
		}
	}
	
	/* Font */

	/*Logo Size*/
	function set_logo_dimensioins(){
	
		$logo_height = get_field('logo_height','options');
		$margin_top = round($logo_height/2);
		if($logo_height<=0||!isset($logo_height)){
		  $logo_height = '26';
		  $margin_top = '13';
		}
		
		$logo_width = get_field('logo_width','options');
		if($logo_width<=0||!isset($logo_width)){
		  $logo_width = '100';
		}
		
		 echo   '.center-logo {
				position: absolute;
				top: 50%;
				overflow: hidden;';
				
		echo    'margin-top: -'.$margin_top.'px;';
		echo 	'height: '.$logo_height.'px;';
		echo 	'width: '.$logo_width.'px;';			
		echo    '}';
		
		echo ' .center-logo img{
			width:100%;
		}';
	
	}
	/*Logo Size*/
	
	/*Support Language Translation*/		
		function st_hybrid_theme_setup(){
			load_theme_textdomain('hybrid_lang', get_template_directory().'/lang');
		}
		add_action('after_setup_theme', 'st_hybrid_theme_setup');
	/*Support Language Translation*/
	
	/*Adding post views to blog post*/
	add_action('wp_ajax_hybrid_insert_views', 'hybrid_insert_views');
	add_action('wp_ajax_nopriv_hybrid_insert_views', 'hybrid_insert_views');
	function hybrid_insert_views()
	{
		$post_id = $_POST["post_id"];
		add_view($post_id);
		echo get_post_meta($post_id,'hybrid_view',true);
		die();
	}
	function add_view($post_id)
	{
		$view = get_post_meta($post_id,'hybrid_view',true);
		$view = $view + 1;
		update_post_meta($post_id,'hybrid_view',$view);
	}
	add_action('publish_post', 'add_custom_view');
	function add_custom_view($post_id)
	{
		if ($post->post_date != $post->post_modified)
		{
			global $post;
			setup_postdata( $post );
		 
			if ($_POST['post'] == $post->post_type )
			{
				add_post_meta($post_id, 'hybrid_view', 0, true);
			}			
		}
		return true;
	}
	/*Adding view to custom post*/	
	
	/*Load more posts ajax*/
	add_action('wp_ajax_load_posts', 'load_posts');
	add_action('wp_ajax_nopriv_load_posts', 'load_posts');	
	function load_posts(){
		//$post_id = $_POST["post_id"];
		$count = $_POST["count_posts"];
		$num_of_posts =  $_POST["num_of_posts"];
		$items = array();
		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
		$paged += $count;
		$args = array(			
						'ignore_sticky_posts' =>1,
                        'post_type'         => 'post',
						'posts_per_page' => $num_of_posts,
                        'paged'             => $paged
						
                    );
					
					$the_Query = new WP_Query($args);
					while ($the_Query->have_posts()){
						$the_Query->the_post(); 	
											
						$item =	'<div class="item blog-item span3">';
						
						$image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),'home1-blog',false);
						$post_categories = wp_get_post_categories( get_the_ID() );								
						$categories = '';	
						foreach($post_categories as $c){
							$cat = get_category( $c );									
							$categories = $categories.' '.$cat->name;
						}
									
                        $item .= '<a href="'.get_permalink(get_the_ID()).'"><img src="'.$image[0].'"></a>';
						
						$item .= '<div class="blog-desc">';
						$item .='<div class="border-container">';
						$item .= '<div class="comment-size-box"><p class="comment-number">';
								 
						$item .= get_comments_number(get_the_ID());
													
						$item .=  '</p></div>';
						$item .= '<div class="triangle-box">';
						$item .=	'<div class="triangle triangle-border"></div>';
						$item .=	'<div class="triangle triangle-body"></div>';
								$item .=	'</div>';
								$item .=	'</div>';
								$item .=    '<a href="'.get_permalink(get_the_ID()).'">';
								$item .=	'<p class="post-title">'.get_the_title().'</p>';
								$item .='<p class="post-categoty">';
									// $cat = get_the_category($post->ID);
								 $item .= 'Posted in '.$categories.'</p>';
										$excerpt = get_the_excerpt();
								$item .= '</a>';		
								$item .='<p class="desc">';
								$item .= $excerpt; 
								$item .=	'</p>';
								$item .='</div>';
							$item .='</div>';	
						
						array_push($items,$item);
					}
					
			echo json_encode($items);
		die();
	}
	
	add_action('wp_ajax_load_testmonials', 'load_testmonials');
	add_action('wp_ajax_nopriv_load_testmonials', 'load_testmonials');
	function load_testmonials(){
		
		$paged_ = $_POST["paged_"];
		$num_of_posts =  $_POST["num_of_posts"];
		$items = array();
		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
		$paged += $paged_;
		$args = array(
                        'post_type'         => 'testmonials_post',
						'posts_per_page' => $num_of_posts,
                        'paged'             => $paged
						
                    );					
					$the_Query = new WP_Query($args);
					$count = false;
					if(!($num_of_posts%2==0))
						$count = true;
					while ($the_Query->have_posts()){
						$the_Query->the_post(); 
						 
						 $excerpt = get_the_content();
						 $name = get_the_title();
						 $link  = get_field("link");
						 $position  = get_field("position");						
					   if(!$count){
								$item = '<div class="up-container animated slideInDown">';
								$item .= '	<div class="testmonial-container">';
								$item .= '<div class="testmonial-inner testmonial-quote testmonial-border">';
								$item .= '<p class="comment">';
								$item .= $excerpt;
								$item .= '</p>';
								$item .= '</div>';
								$item .= '<div class="testmonial-inner testmonial-arrow-first">';
								$item .= '<div class="testmonial-triangle-border"></div>';
								$item .= '<div class="testmonial-triangle-body"></div>';
								$item .= '</div>';
								$item .= '<div class="testmonial-inner testmonial-author testmonial-right">';
								if(get_field("link")){
									$item .= '<a href="'.$link.'"><p class="post-title">';
									$item .= $name;
									$item .= '</p><p class="post-categoty capitalize">';
									$item .= $position;
									$item .= '</p></a></div>';
								}
								else{
									$item .= '<p class="post-title">';
									$item .= $name;
									$item .= '</p><p class="post-categoty capitalize">';
									$item .= $position;
									$item .= '</p></div>';
								}
								$item .= '</div>';
								$item .= '</div>';
							$count = true;
						}
						else
						{
							$item = '<div class="up-container animated slideInDown">
											<div class="testmonial-container">';
							$item .= '<div class="testmonial-inner testmonial-author">';
							if(get_field("link")){
									$item .= '<a href="'.$link.'"><p class="post-title">';
									$item .= $name;
									$item .= '</p><p class="post-categoty capitalize">';
									$item .= $position;
									$item .= '</p></a></div>';
							}
							else{
									$item .= '<p class="post-title">';
									$item .= $name;
									$item .= '</p><p class="post-categoty capitalize">';
									$item .= $position;
									$item .= '</p></div>';
							}
							$item .= '<div class="testmonial-inner testmonial-arrow-second">
												<div class="testmonial-triangle-border"></div>
													<div class="testmonial-triangle-body"></div>
										  </div>';
							$item .= '<div class="testmonial-inner testmonial-quote testmonial-border-left"><p class="comment">';
							$item .= $excerpt;
							$item .=	'</p></div>';
							$item .= '</div></div>';
							$count = false;
						}						
						array_push($items,$item);					
					}
			echo json_encode($items);
		die();
	}
	
	add_action('wp_ajax_loadmore_works1', 'loadmore_works1');
	add_action('wp_ajax_nopriv_loadmore_works1', 'loadmore_works1');
	function loadmore_works1(){
		
		$paged_ = $_POST["paged_"];
		$num_of_posts =  $_POST["num_of_posts"];
		$items = array();
		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
		$paged += $paged_;
		$args = array(
                        'post_type'         => 'work_post',
						'posts_per_page' => $num_of_posts,
                        'paged'             => $paged
						
                    );					
					$the_Query = new WP_Query($args);
					$counter = true;
					while ($the_Query->have_posts()){
						$the_Query->the_post(); 						
						
						$current_categories = get_the_terms(get_the_ID(),'works_category');
						$className = '';
						if( $current_categories)
						{
							foreach($current_categories as $cat)
							{
								$className = $className.' '.str_replace(' ','_',$cat->name);
							}
						}
							$item = '<a href="'.get_permalink().'">';
							if( $_POST["from_page"] == "#portfolio2-items")
								$item .= '<div class="portfolio-item span6 '.$className.'" >';
								else
								$item .= '<div class="portfolio-item '.$className.' span3" >';
							if(has_post_thumbnail()){
							
								
								$image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),'work_post_Slider',false);
								if( $_POST["from_page"] == "#portfolio2-items")
									$image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),'home2-featured',false);
								$item .= '<div class="image-container">';
							
								$item .= '<img src="'.$image[0].'" alt="T 2"/>';
								$item .= '<div class="image-hover"></div></div>';
							}
								$item .= '<h4>'.get_the_title().'</h4>';
								$item .= '<p class="post-categoty capitalize"></p>';
								$item .= '</div></a>';	
						array_push($items,$item);					
					}
			echo json_encode($items);
		die();
	}
	/*Load more posts ajax*/

	/* Comments */
	add_filter('get_avatar','change_avatar_css');		
		function change_avatar_css($class) {
			$class = str_replace("class='avatar", "class=' img-60 ", $class) ;
			return $class;
		}
		
	if ( ! function_exists( 'hybrid_comment' ) ) :
	/**
	 * Template for comments and pingbacks.
	 *
	 * To override this walker in a child theme without modifying the comments template
	 * simply create your own hybrid_comment(), and that function will be used instead.
	 *
	 * Used as a callback by wp_list_comments() for displaying the comments.	
	 */
		function hybrid_comment( $comment, $args, $depth ) {
			$GLOBALS['comment'] = $comment;
			switch ( $comment->comment_type ) :
				case 'pingback' :
				case 'trackback' :
				// Display trackbacks differently than normal comments.
			?>
			<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
				<p><?php _e( 'Pingback:', 'hybrid_lang' ); ?> <?php comment_author_link(); ?> <?php edit_comment_link( __( '(Edit)', 'hybrid_lang' ), '<span class="edit-link">', '</span>' ); ?></p>
			<?php
					break;
				default :
				// Proceed with normal comments.
				global $post;
			?>
				<ul>
					<li>
						<div class="img-container">
						<?php
								$avatar_size = 60;
								if ( '0' != $comment->comment_parent )
									$avatar_size = 39;
								echo get_avatar( $comment, $avatar_size );
								?>						
						</div>
						<div class="comment-info">							
							<?php comment_reply_link( array_merge( $args, array( 'reply_text' => __( '<input type="submit" class="btn capitalize reply" value="reply">'), 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) );?>
							<p class="post-title"><a href=""><?php echo get_comment_author_link();?></a></p>
							<?php
								echo '<p class="post-categoty grey">'.get_comment_date().' , '.get_comment_time().'</p>';
							?>
							<p class="comment">
							<?php $coment_con  = get_comment_text(); ?>
							<?php echo $coment_con;?>
							</p>
						</div>
					</li>
				</ul>
			<?php
				break;
			endswitch; // end comment_type check
		}
		endif;
	/* Comments */
?>